/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenGrownUpEvent;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class EntityAICitizenChild
extends Goal {
    protected final EntityCitizen child;
    private final Random rand = new Random();
    private final ITickRateStateMachine<IAIState> stateMachine;
    private int actionTimer = 0;
    private static final int START_FOLLOW_DISTANCE = 10;
    private int aiActiveTime = 0;
    private static final int MIN_ACTIVE_TIME = 4000;
    private static final int BONUS_TIME_COLONY = 2000;
    private WeakReference<Entity> followTarget = new WeakReference<Object>(null);
    private BlockPos followStart;
    private BlockPos visitHutPos;
    private PathResult visitingPath;

    public EntityAICitizenChild(@NotNull EntityCitizen citizen) {
        this.child = citizen;
        super.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<State>(State.IDLE, this::handleAIException);
        this.stateMachine.addTransition(new AIEventTarget(AIBlockingEventType.STATE_BLOCKING, this::updateTimers, this.stateMachine::getState, 1));
        this.stateMachine.addTransition(new AIEventTarget(AIBlockingEventType.EVENT, this::tryGrowUp, () -> State.IDLE, 500));
        this.stateMachine.addTransition(new AITarget(State.IDLE, this::searchEntityToFollow, () -> State.FOLLOWING, 150));
        this.stateMachine.addTransition(new AITarget(State.IDLE, this::isReadyForActivity, () -> State.VISITING, 300));
        this.stateMachine.addTransition(new AITarget((IAIState)State.FOLLOWING, this::followingEntity, 20));
        this.stateMachine.addTransition(new AITarget((IAIState)State.VISITING, this::visitHuts, 120));
    }

    private void handleAIException(RuntimeException ex) {
        this.stateMachine.reset();
        Log.getLogger().warn("EntityAICitizenChild Child: " + this.child.func_200200_C_() + " threw an exception:", (Throwable)ex);
    }

    private boolean updateTimers() {
        if (this.actionTimer > 0) {
            this.actionTimer -= ((Integer)MineColonies.getConfig().getServer().updateRate.get()).intValue();
        }
        this.aiActiveTime += (Integer)MineColonies.getConfig().getServer().updateRate.get() * (this.child.getCitizenJobHandler().getColonyJob() instanceof JobPupil ? 2 : 1);
        return false;
    }

    private boolean isReadyForActivity() {
        return this.actionTimer <= 0;
    }

    private void setDelayForNextAction() {
        this.actionTimer = this.rand.nextInt(2400) + 3600;
    }

    private boolean searchEntityToFollow() {
        if (!this.isReadyForActivity()) {
            return false;
        }
        CompatibilityUtils.getWorldFromCitizen(this.child).func_175674_a((Entity)this.child, this.child.func_174813_aQ().func_72321_a(10.0, 1.0, 10.0), target -> target.func_70089_S() && (target instanceof AgeableEntity || target instanceof PlayerEntity)).stream().findFirst().ifPresent(entity -> {
            this.followTarget = new WeakReference<Entity>((Entity)entity);
        });
        if (this.followTarget.get() != null) {
            this.actionTimer = this.rand.nextInt(600) + 600;
            this.followStart = this.child.func_233580_cy_();
            return true;
        }
        return false;
    }

    private IAIState followingEntity() {
        if (this.actionTimer <= 0 || this.followTarget.get() == null) {
            this.child.getNavigation().moveToXYZ(this.followStart.func_177958_n(), this.followStart.func_177956_o(), this.followStart.func_177952_p(), 1.0);
            this.setDelayForNextAction();
            return State.IDLE;
        }
        this.child.getNavigation().moveToLivingEntity((Entity)this.followTarget.get(), 1.0);
        return State.FOLLOWING;
    }

    private IAIState visitHuts() {
        if (this.visitingPath == null && this.child.getCitizenColonyHandler().getColony() != null) {
            if (this.actionTimer <= 0 && this.visitHutPos == null) {
                this.actionTimer = 3600;
            }
            int index = this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().size();
            index = this.rand.nextInt(index);
            ArrayList<BlockPos> buildings = new ArrayList<BlockPos>(this.child.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().keySet());
            this.visitHutPos = (BlockPos)buildings.get(index);
            this.visitingPath = this.child.getNavigation().moveToXYZ(this.visitHutPos.func_177958_n(), this.visitHutPos.func_177956_o(), this.visitHutPos.func_177952_p(), 1.0);
        }
        if (this.actionTimer > 0) {
            if (this.visitingPath != null && !this.visitingPath.isInProgress()) {
                this.visitingPath = this.child.getNavigation().moveToXYZ(this.visitHutPos.func_177958_n(), this.visitHutPos.func_177956_o(), this.visitHutPos.func_177952_p(), 1.0);
            }
            return State.VISITING;
        }
        this.child.getNavigation().func_75499_g();
        this.visitingPath = null;
        this.visitHutPos = null;
        this.setDelayForNextAction();
        return State.IDLE;
    }

    private boolean tryGrowUp() {
        if (this.child.getCitizenColonyHandler().getColony() != null && this.child.getCitizenColonyHandler().getColony().useAdditionalChildTime(2000)) {
            this.aiActiveTime += 2000;
        }
        if (this.aiActiveTime >= 4000) {
            if (!this.child.func_70631_g_()) {
                return true;
            }
            double growthModifier = (Double)MineColonies.getConfig().getServer().growthModifier.get() * (1.0 + this.child.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GROWTH));
            if (this.rand.nextInt((int)(70.0 / growthModifier) + 1) == 0 || (double)this.aiActiveTime > 70000.0 / growthModifier) {
                this.child.getCitizenColonyHandler().getColony().getEventDescriptionManager().addEventDescription(new CitizenGrownUpEvent(this.child.func_233580_cy_(), this.child.getCitizenData().getName()));
                LanguageHandler.sendPlayersMessage(this.child.getCitizenColonyHandler().getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.progress.childGrow", (Object[])new Object[]{this.child.func_200200_C_().getString()});
                this.child.setIsChild(false);
                this.child.setTextureDirty();
                this.child.getCitizenData().setIsChild(false);
                return true;
            }
        }
        return false;
    }

    public boolean func_75250_a() {
        return this.child.func_70631_g_() && this.child.getCitizenData() != null;
    }

    public boolean func_75253_b() {
        if (this.child.getDesiredActivity() == DesiredActivity.SLEEP || !this.child.func_70631_g_() || this.child.getCitizenData() == null) {
            return false;
        }
        this.stateMachine.tick();
        return true;
    }

    public static enum State implements IAIState
    {
        IDLE,
        BORED,
        PLAYING,
        VISITING,
        FOLLOWING;


        @Override
        public boolean isOkayToEat() {
            return true;
        }
    }
}

